<?php 

namespace App\Controllers;
use App\Models\comprasModels;
use App\Models\TemporalCompraModel;
use App\Models\DetallescomprasModels;
use App\Models\ProductosModels;
use App\Models\configuracionesModels;
use App\Models\detalle_roles_permisosModels;


class Compras extends BaseController{
	
	protected $compras,$temporal_compras,$detalle_compra,$productos,$configuraciones;
	protected $reglas,$session,$detalleRolesPermisos;
	
	
	public function __construct(){
		
		$this->compras=new ComprasModels();
		$this->detalle_compra=new DetallesComprasModels();
        $this->configuraciones=new configuracionesModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
        
		
		
		helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			],
			'nombre_corto'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				]
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function index($activo=1){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCompra');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
        
        
		$compras=$this->compras->where('activo',$activo)->findAll();
		$data=['titulo'=>'Compras','compras'=>$compras];
		
		
        echo view('header');
		echo view('compras/compras', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function nuevo(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubNuevaCompra');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		
		
		$data=['titulo'=>'Nueva compra'];
		
		
        echo view('header');
		echo view('compras/nuevo', $data);
		echo view('footer');
		
	}
	
	
	
	
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function agregar(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$data=['titulo'=>'Agregar compra'];
		
		
        echo view('header');
		echo view('compras/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function guarda(){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		$id_compra=$this->request->getPost('id_compra');
		$total=preg_replace('/[\$,]/', '', $this->request->getPost('total'));
        
        
		$session= session();
       
		
      
		$resultadoID=$this->compras->insertaCompra($id_compra,$total,$session->id_id);
		
		
		$this->temporal_compras=new TemporalCompraModel();
		
		if($resultadoID){
			
			
			$resultadoCompra=$this->temporal_compras->porCompra($id_compra);
			
			foreach($resultadoCompra as $row){
				
				
				$this->detalle_compra->save([
					'id_compra'=>$resultadoID,
					'id_producto'=>$row['id_producto'],
					'nombre'=>$row['nombre'],
					'cantidad'=>$row['cantidad'],
					'precio'=>$row['precio'],
					
					
				]);
                
                $this->productos=new productosModels();
                $this->productos->actualizaStock($row['id_producto'],$row['cantidad']);
                
                
			}
            $this->temporal_compras->eliminarCompra($id_compra);
		}
		return redirect()->to(base_url()."/compras/muestraCompraPdf/".$resultadoID);
			
	}
 //--------------------------------------------------------------------------------------------------------------------------------------------------------------   
    function muestraCompraPdf($id_compra){
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $data['id_compra']=$id_compra;
        echo view ('header');
        echo view ('compras/ver_compra_pdf',$data);
        echo view ('footer');
        
        
    }
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
     function generaCompraPdf($id_compra){
         if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
         $datosCompra=$this->compras->where('id', $id_compra)->first();
         $detalleCompra=$this->detalle_compra->select('*')->where('id_compra', $id_compra)->findAll();
         
          $nombreTienda=$this->configuraciones->select('valor')->where('nombre', 'n_nombre_ticket')->get()->getRow()->valor;
          $direccionTienda=$this->configuraciones->select('valor')->where('nombre', 'n_direccion')->get()->getRow()->valor;
         
                 $pdf =new \FPDF('L','mm','Letter');
                 $pdf->AddPage();
         $pdf->SetMargins(10,10,10);
         $pdf->SetTitle("Compra");
         $pdf->SetFont('Arial','B',14);
          $pdf->Cell(0,5,'Entrada de productos',0,1,'C');
          $pdf->SetFont('Arial','B',12);
         
         
         $pdf->Image(base_url().'/dist/img/logo/CENTRO-PIEL.png',230,0,40,40, 'PNG');
         
           $pdf->Cell(80,5,$nombreTienda,0,1,'L');
           $pdf->Cell(22,5,utf8_decode('Dirección:'),0,0,'L');
         $pdf->SetFont('Arial','',10);
         $pdf->Cell(80,5,utf8_decode($direccionTienda),0,1,'L');
         
         $pdf->SetFont('Arial','B',12);
         
         
           $pdf->Cell(30,5,'Fecha y Hora:',0,0,'L');
         
         
         $pdf->SetFont('Arial','',10);
         $pdf->Cell(80,5,$datosCompra['fecha_alta'],0,1,'L');
         
          $pdf->Ln();
         
          $pdf->SetFont('Arial','B',10);
         $pdf->SetFillColor(0,0,0,0);
         $pdf->SetTextColor(255,255,255);
         $pdf->Cell(0,5,'Detalle de productos',1,1, 'C', 1);
         $pdf->SetTextColor(0,0,0);
         $pdf->Cell(14,5,'No',1,0, 'L');
         $pdf->Cell(30,5,utf8_decode('Código'),1,0, 'L');
          $pdf->Cell(120.5,5,'Nombre',1,0, 'L');
          $pdf->Cell(30,5,'Precio',1,0, 'L');
          $pdf->Cell(30,5,'Cantidad',1,0, 'L');
         $pdf->Cell(35,5,'Importe',1,1, 'L');
         $pdf->SetFont('Arial','',8);
         
         $contador=1;
         foreach( $detalleCompra as $row){
             
            $pdf->Cell(14,5,$contador,1,0, 'L');
         $pdf->Cell(30,5,$row['id_producto'],1,0, 'L');
          $pdf->Cell(120.5,5,$row['nombre'],1,0, 'L');
          $pdf->Cell(30,5,$row['precio'],1,0, 'L');
          $pdf->Cell(30,5,$row['cantidad'],1,0, 'L');
             $importe=number_format($row['precio']*$row['cantidad'],2,'.',',');
         $pdf->Cell(35,5,'$'.$importe,1,1, 'R'); 
             $contador++;
             
         }
         $pdf->Ln();
         
          $pdf->SetFont('Arial','B',10);
         
        $pdf->Cell(0,5,'Total $'.number_format($datosCompra['total'],2,'.','.'),0,1,'R');
                 $this->response->setHeader('Content-Type', 'application/pdf');
                     $pdf->Output("compra_pdf.pdf", "I");
         
      
         
         
         
         
        
    }

}






?>