<?php 

namespace App\Controllers;
use App\Models\juiciosModels;
use App\Models\detalle_roles_permisosModels;

class Juicios extends BaseController{
	
	protected $juicios;
	protected $reglas,$session,$detalleRolesPermisos;
	
	public function __construct(){
		
		$this->juicios=new JuiciosModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function index($activo=1){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$categorias=$this->juicios->where('activo',$activo)->findAll();
		$data=['titulo'=>'Tipo de juicios','datos'=>$categorias];
		
		
        echo view('header');
		echo view('juicios/juicios', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function agregar(){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }

     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juicios');
           
           
            
        }
    
    
    
    
		
		
		$data=['titulo'=>'Agregar nuevo Tipo de Juicio'];
		
		
        echo view('header');
		echo view('juicios/agregar', $data);
		echo view('footer');
		
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------

	public function insertar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->juicios->save(['tipo'=> $this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/juicios');
		
		}else{
			
			$data=['titulo'=>'Agregar nuevo Tipo de Juicio', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('juicios/agregar', $data);
		echo view('footer');
		
			
		}
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function editar($id, $valid=null){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juicios');
           
           
            
        }
		
		$unidad=$this->juicios->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar Tipo de Juicio', 'datos'=>$unidad,'validation'=> $valid];
		}else{
			$data=['titulo'=>'Editar Tipo de Juicio', 'datos'=>$unidad];
			
		}
		
        echo view('header');
		echo view('juicios/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function actualizar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->juicios->update($this->request->getPost('id'),[ 'tipo'=>$this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/juicios');
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/juicios');
           
           
            
        }
		
		$this->juicios->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/juicios');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminados($activo=0){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		$categorias=$this->juicios->where('activo',$activo)->findAll();
		$data=['titulo'=>'Tipo de Juicios eliminadas','datos'=>$categorias];
		
		
        echo view('header');
		echo view('juicios/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
		public function reingresar($id){
            

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->juicios->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/juicios');
		
		
        
		
	}
	
	
	
}






?>