<?php 

namespace App\Controllers;
use App\Models\categoriasModels;
use App\Models\detalle_roles_permisosModels;

class Categorias extends BaseController{
	
	protected $categorias;
	protected $reglas,$session,$detalleRolesPermisos;
	
	public function __construct(){
		
		$this->categorias=new CategoriasModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
	helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			]
			
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function index($activo=1){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
    
    $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCategorias');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
		$categorias=$this->categorias->where('activo',$activo)->findAll();
		$data=['titulo'=>'Categorias','datos'=>$categorias];
		
		
        echo view('header');
		echo view('categorias/categorias', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function agregar(){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }

     $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
    
    
    
    
		
		
		$data=['titulo'=>'Agregar categoria'];
		
		
        echo view('header');
		echo view('categorias/agregar', $data);
		echo view('footer');
		
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------

	public function insertar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->categorias->save(['nombre'=> $this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/categorias');
		
		}else{
			
			$data=['titulo'=>'Agregar categoria', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('categorias/agregar', $data);
		echo view('footer');
		
			
		}
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function editar($id, $valid=null){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		
		$unidad=$this->categorias->where('id',$id)->first();
		
		if($valid != null){
		$data=['titulo'=>'Editar unidad', 'datos'=>$unidad,'validation'=> $valid];
		}else{
			$data=['titulo'=>'Editar unidad', 'datos'=>$unidad];
			
		}
		
        echo view('header');
		echo view('categorias/editar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function actualizar(){
		

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		$this->categorias->update($this->request->getPost('id'),[ 'nombre'=>$this->request->getPost('nombre')]);
		return redirect()->to(base_url().'/categorias');
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		
		$this->categorias->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/categorias');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function eliminados($activo=0){
        

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CategoriasEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/categorias');
           
           
            
        }
		$categorias=$this->categorias->where('activo',$activo)->findAll();
		$data=['titulo'=>'Categorias eliminadas','datos'=>$categorias];
		
		
        echo view('header');
		echo view('categorias/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
		public function reingresar($id){
            

if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->categorias->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/categorias');
		
		
        
		
	}
	
	
	
}






?>