<?php 

namespace App\Controllers;
use App\Models\unidadesModels;
use App\Models\detalle_roles_permisosModels;

class Unidades extends BaseController{
	
	protected $unidades;
	protected $reglas,$session,$detalleRolesPermisos;
	
	
	public function __construct(){
		
		$this->unidades=new UnidadesModels();
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
        
		helper(['form']);
		$this->reglas=[
			'nombre'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			],
			'nombre_corto'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				]
			];
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function index($activo=1){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
          $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubUnidades');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
        
		$unidades=$this->unidades->where('activo',$activo)->findAll();
		$data=['titulo'=>'Unidades','datos'=>$unidades];
		
		
        echo view('header');
		echo view('unidades/unidades', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function agregar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
          $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UnidadesAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/unidades');
           
           
            
        }
		$data=['titulo'=>'Agregar unidad'];
		
		
        echo view('header');
		echo view('unidades/agregar', $data);
		echo view('footer');
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------    
	public function insertar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
			
			$this->unidades->save(['nombre'=> $this->request->getPost('nombre'), 'nombre_corto'=>$this->request->getPost('nombre_corto')]);
		return redirect()->to(base_url().'/unidades');
			
		}
		
		else {
			$data=['titulo'=>'Agregar unidad', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('unidades/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function editar($id, $valid=null){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UnidadesEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/unidades');
           
           
            
        }
		
		$unidad = $this->unidades->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar unidad', 'datos'=>$unidad, 'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar unidad', 'datos'=>$unidad];
		}
		
		
		
        echo view('header');
		echo view('unidades/editar', $data);
		echo view('footer');
		
	}
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function actualizar(){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		
		$this->unidades->update($this->request->getPost('id'),[ 'nombre'=>$this->request->getPost('nombre'),'nombre_corto'=>$this->request->getPost('nombre_corto')]);
		return redirect()->to(base_url().'/unidades');
		
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	public function eliminar($id){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		  $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UnidadesEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/unidades');
           
           
            
        }
		
		$this->unidades->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/unidades');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminados($activo=0){
        
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'UnidadesEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/unidades');
           
           
            
        }
        
        
		$unidades=$this->unidades->where('activo',$activo)->findAll();
		$data=['titulo'=>'Unidades eliminadas','datos'=>$unidades];
		
		
        echo view('header');
		echo view('unidades/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
public function reingresar($id){
            
if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->unidades->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/unidades');
		
		
        
		
	}
	
	
	
}






?>