<?php 

namespace App\Controllers;
use App\Models\cajasModels;
use App\Models\detalle_roles_permisosModels;
use App\Models\arqueoModels;
use App\Models\VentasModels;

class Cajas extends BaseController{
	
	protected $cajas;
	protected $reglas,$session,$detalleRolesPermisos,$arqueoModel,$ventasModels;
    
	
	
	public function __construct(){
		
		$this->cajas=new CajasModels();
        $this->arqueoModel=new arqueoModels();
         $this->ventasModels=new VentasModels();
        
        $this->session=session();
        $this->detalleRolesPermisos=new detalle_roles_permisosModels();
		helper(['form']);
		$this->reglas=[
			'numCaja'=>[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
			],
			'nombre'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				],			
			'folio'=>
			[
					   'rules'=>'required',
					   'errors'=>[
						   'required'=> 'El campo {field} es obligatorio.'
					   ]
				]
			];
	}
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	public function index($activo=1){
        
        if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'SubCajas');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/inicio');
           
           
            
        }
        
        
		$cajas=$this->cajas->where('activo',$activo)->findAll();
		$data=['titulo'=>'Cajas','datos'=>$cajas];
		
		
        echo view('header');
		echo view('cajas/cajas', $data);
		echo view('footer');
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------	
	public function agregar(){
		   if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CajasAgregar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cajas');
           
           
            
        }
		
		$data=['titulo'=>'Agregar caja'];
		
		
        echo view('header');
		echo view('cajas/agregar', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function insertar(){
		
           if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        
        
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
			
			$this->cajas->save(['numero_caja'=> $this->request->getPost('numCaja'), 'nombre'=>$this->request->getPost('nombre'), 'folio'=>$this->request->getPost('folio')]);
		return redirect()->to(base_url().'/cajas');
			
		}
		
		else {
			$data=['titulo'=>'Agregar caja', 'validation'=> $this->validator];
		
		
        echo view('header');
		echo view('cajas/agregar', $data);
		echo view('footer');
			
		}
		
        
		
	}
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function editar($id, $valid=null){
        
           if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CajasEditar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cajas');
           
           
            
        }
		
		$caja = $this->cajas->where('id',$id)->first();
		
		if($valid != null){
			$data=['titulo'=>'Editar caja', 'caj'=>$caja, 'validation'=> $valid];
		}
		else {
			$data=['titulo'=>'Editar caja', 'caj'=>$caja];
		}
		
		
		
        echo view('header');
		echo view('cajas/editar', $data);
		echo view('footer');
		
	}
	
	
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function actualizar(){
		
        
           if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		if($this->request->getMethod()=="post" && $this->validate($this->reglas)){
		
		$this->cajas->update($this->request->getPost('id'),[ 'numero_caja'=>$this->request->getPost('numCaja'),'nombre'=>$this->request->getPost('nombre'),'folio'=>$this->request->getPost('folio')]);
		return redirect()->to(base_url().'/cajas');
		
		
		}else{
			
			return $this->editar($this->request->getPost('id'),$this->validator);
			
		}
		
	}
	
	
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminar($id){
		
        
           if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CajasEliminar');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cajas');
           
           
            
        }
		
		$this->cajas->update($id,['activo'=> 0]);
		return redirect()->to(base_url().'/cajas');
		
		
        
		
	}
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
	public function eliminados($activo=0){
        
           if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
        $permiso=$this->detalleRolesPermisos->verificaPermisos($this->session->id_rol,'CajasEliminados');
        
        if(!$permiso){
            
            
            
            
            return redirect()->to(base_url().'/cajas');
           
           
            
        }
        
        
		$cajas=$this->cajas->where('activo',$activo)->findAll();
		$data=['titulo'=>'Cajas eliminadas','datos'=>$cajas];
		
		
        echo view('header');
		echo view('cajas/eliminadas', $data);
		echo view('footer');
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function reingresar($id){
            
               if (!isset($this->session->id_usuario)){
            return redirect()->to(base_url());
        }
		
		
		$this->cajas->update($id,['activo'=> 1]);
		return redirect()->to(base_url().'/cajas');
		
		
        
		
	}
	
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function arqueo($idCaja){
            
            $arqueos =$this->arqueoModel->getDatos($idCaja);
            
            $data=['titulo'=>'Cierre de caja','datos'=>$arqueos];
            
            echo view('header');
             echo view('cajas/arqueo', $data);
             echo view('footer');
            
        
		
	}
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function nuevo_arqueo(){
            
        $session=session();
            
            
             $existe=$this->arqueoModel->where(['id_caja'=>$session->id_caja, 'estatus'=>1])->countAllResults();
                
                if($existe > 0){
                    
                    echo 'La caja ya esta habierta';
                    exit;
                }
            
            
            if ($this->request->getMethod()=="post"){
                
              
                $fecha=date('Y-m-d h:i:s');
                $existe=0;
               
                
                
                $this->arqueoModel->save(['id_caja'=>$session->id_caja, 'id_usuario'=>$session->id_id, 'fecha_inicio'=>$fecha,'monto_inicial'=>$this->request->getPost('montoInicial'),'estatus'=>1]);
                
                return redirect()->to(base_url().'/cajas');
                
            }else{
                
                $caja=$this->cajas->where('id', $session->id_caja)->first();
                $data=['titulo'=>'Apertura de caja','caja'=>$caja, 'session'=>$session];
            
            echo view('header');
             echo view('cajas/nuevo_arqueo', $data);
             echo view('footer');
                
                
            } 
        
		
	}
    
    
    
//--------------------------------------------------------------------------------------------------------------------------------------------------------------
		public function cierre(){
            
        $session=session();
            
            
            
            
            if ($this->request->getMethod()=="post"){
                
                
                
                
              
                $fecha=date('Y-m-d h:i:s');
              
               
                
                
                $this->arqueoModel->update($this->request->getPost('id_arqueo'),['fecha_fin'=>$fecha,'monto_final'=>$this->request->getPost('montoFinal'),'total_ventas'=>$this->request->getPost('totalVentas'),'estatus'=>0]);
                
                return redirect()->to(base_url().'/cajas');
                
                
                
                
                
                
                
            }else{
                
                
                
                $montoTotal=$this->ventasModels->totalDia(date('Y-m-d'));
                $totalVentas=$this->ventasModels->totalVentas(date('Y-m-d'),$session->id_id);
                
                
                
                
                
                
                
                
                
                $arqueo=$this->arqueoModel->where(['id_caja'=>$session->id_caja, 'estatus'=>1])->first();
                $caja=$this->cajas->where('id', $session->id_caja)->first();
                
                $data=['titulo'=>'Cierre de caja','caja'=>$caja, 'session'=>$session, 'arqueo'=>$arqueo, 'monto'=>$montoTotal, 'ventaTotal'=>$totalVentas];
            
            echo view('header');
             echo view('cajas/cerrar', $data);
             echo view('footer');
                
                
            } 
        
		
	}
		    
				
	
}






?>